clear
set more off
capture log close
global raw "/disk/agedisk2/mcbs/cost_and_use/data/stata"

// ******************************
// These variables need to be set

local yr   =	97
local year =	1997
local pce  = 	85.433

// ******************************

global folder "/disk/homedirs/frenche/research/clean/`year'"
log using $folder/`year'.log, replace

// merge all 1997 datasets together

use $raw/ric1_c`yr'.dta
sort baseid
save $folder/ric1_c`yr'.dta, replace
clear

use $raw/ric2_c`yr'.dta
sort baseid
save $folder/ric2_c`yr'.dta, replace
clear

use $raw/ric2f_c`yr'.dta
sort baseid
save $folder/ric2f_c`yr'.dta, replace
clear

use $raw/ric4_c`yr'.dta
sort baseid
save $folder/ric4_c`yr'.dta, replace
clear

use $raw/ric9_c`yr'.dta
sort baseid
save $folder/ric9_c`yr'.dta, replace
clear

use $raw/rica_c`yr'.dta
sort baseid
save $folder/rica_c`yr'.dta, replace
clear


use $raw/rick_c`yr'.dta
sort baseid
save $folder/rick_c`yr'.dta, replace
clear

use $raw/ricx_c`yr'.dta
sort baseid
save $folder/ricx_c`yr'.dta, replace
clear

use $raw/ricps_c`yr'.dta
sort baseid
save $folder/ricps_c`yr'.dta, replace
clear

use $folder/ric1_c`yr'.dta
merge baseid using $folder/ric2_c`yr'.dta
drop _merge
sort baseid
merge baseid using $folder/ric2f_c`yr'.dta
drop _merge
sort baseid
merge baseid using $folder/ric4_c`yr'.dta
drop _merge
sort baseid
merge baseid using $folder/ric9_c`yr'.dta
drop _merge
sort baseid
merge baseid using $folder/rica_c`yr'.dta
drop _merge
sort baseid
merge baseid using $folder/rick_c`yr'.dta
drop _merge
sort baseid
merge baseid using $folder/ricx_c`yr'.dta
drop _merge
sort baseid
merge baseid using $folder/ricps_c`yr'.dta
drop _merge
sort baseid

// population weights
// from ricx
gen weights = c`yr'wgt

gen int year = `year'

gen pce = `pce'

// gender
// from ric1
gen byte male = (rostsex==1)

// age
// from rica
gen int age = h_age

// indicator if dead
// from rica
gen byte dead = (h_dod~="")

// health status
// from ric2 if community
// from ric2f if facility
gen byte heal = .
replace heal = 0 if (genhelth==1|genhelth==2|genhelth==3)
replace heal = 1 if (genhelth==4|genhelth==5)
replace heal = 0 if (sphealth==1|sphealth==2|sphealth==3)
replace heal = 1 if (sphealth==4|sphealth==5)

// indicator if married
// from ric1
gen byte married = .
replace married = 0 if spmarsta==2|spmarsta==3|spmarsta==4|spmarsta==5
replace married = 1 if spmarsta==1

// number of days spent in nursing home
// from rick
gen byte nurshome = . 
gen nurshomedays = f_days+s_days
replace nurshome = 0 if nurshomedays<60
replace nurshome = 1 if nurshomedays>=60&nurshomedays<=366

// indicator if participate in medicaid
// from rica
// note: this variable excludes a number of individuals for whom medicaid payments is positive
// we don't know why this is
gen byte medicaidind = h_mcsw=="Y"

// indicator if working
// this variable is missing for 1996-98
gen byte workind = .

// income
// from ric1
drop income
gen income = income_c

// reimbursements
// from ricps
gen totalexp = pamttot
gen oop = pamtoop
gen medicare = pamtcare + pamthmom
gen medicaid = pamtcaid
gen privins = pamthmop + pamtprve + pamtprvi + pamtprvu
gen otherexp = pamtdisc + pamtva + pamtoth

rename pamtoop xpay_oop
rename pamtcare xpay_medicare
rename pamthmom xpay_medicarehmo
rename pamtcaid xpay_medicaid
rename pamthmop xpay_privatehmo
rename pamtprve xpay_emplyspon
rename pamtprvi xpay_ipprinvs
rename pamtprvu xpay_unprinvs
rename pamtdisc xpay_unclib
rename pamtva xpay_va
rename pamtoth xpay_other
rename pamtdu xexp_dental
rename pamthh xexp_home
rename pamthp xexp_hospice
rename pamtip xexp_inpatient
rename pamtiu xexp_inst
rename pamtmp xexp_medprov
rename pamtop xexp_outpatient
rename pamtpm xexp_drugs
rename pamtfa xexp_facility

gen exp_hosp = xexp_inpatient + xexp_outpatient
gen exp_ps = xexp_dental + xexp_medprov
gen exp_nursing = xexp_facility
gen exp_drugs = xexp_drugs
gen exp_other = xexp_home + xexp_hospice + xexp_inst



// premia
// private from ric4
// medicare from rica
// note: for 1996-1997, h_ptaprm and h_ptbprm (part a and part b premium) does not work with stattransfer.
// the two variables were manually transferred to rica2.dta
gen secondaryinsprem = 0
replace secondaryinsprem = tot_prem if tot_prem ~= . 
gen partapremium = h_ptaprm
gen partbpremium = h_ptbprm
gen totpremium = secondaryinsprem+partapremium+partbpremium
gen ooppluspremium = totpremium+oop

keep xexp_* xpay_* exp_* h_dod baseid weights year male age heal nurshome nurshomedays dead pce married medicaidind workind income totalexp oop medicare medicaid privins otherexp secondaryinsprem partapremium partbpremium totpremium ooppluspremium
summ
save $folder/`year'.dta, replace

log close

clear
